--
-- ResetTripComputerEvent
--
-- Author: Sławek Jaskulski
-- Copyright (C) Mod Next, All Rights Reserved.
--

ResetTripComputerEvent = {}

local ResetTripComputerEvent_mt = Class(ResetTripComputerEvent, Event)

InitEventClass(ResetTripComputerEvent, "ResetTripComputerEvent")

---Create instance of Event class
-- @return table self instance of class event
function ResetTripComputerEvent.emptyNew()
  local self = Event.new(ResetTripComputerEvent_mt)

  return self
end

---Create new instance of event
-- @param table vehicle vehicle instance
-- @return table self instance of class event
function ResetTripComputerEvent.new(vehicle)
  local self = ResetTripComputerEvent.emptyNew()

  self.vehicle = vehicle

  return self
end

---Called on client side on join
-- @param number streamId the stream id
-- @param table connection the connection instance
function ResetTripComputerEvent:readStream(streamId, connection)
  self.vehicle = NetworkUtil.readNodeObject(streamId)
  self:run(connection)
end

---Called on server side on join
-- @param number streamId the stream id
-- @param table connection the connection instance
function ResetTripComputerEvent:writeStream(streamId, connection)
  NetworkUtil.writeNodeObject(streamId, self.vehicle)
end

---Run action on receiving side
-- @param table connection the connection instance
function ResetTripComputerEvent:run(connection)
  if not connection:getIsServer() then
    g_server:broadcastEvent(self, false, connection, self.vehicle)
  end

  if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then
    self.vehicle:resetTripComputer(true)
  end
end

---Send event to server or broadcast to clients
-- @param table vehicle vehicle instance
-- @param boolean noEventSend if true, no event will be sent
function ResetTripComputerEvent.sendEvent(vehicle, noEventSend)
  if vehicle ~= nil and vehicle.spec_tripComputer ~= nil and (noEventSend == nil or noEventSend == false) then
    if g_server ~= nil then
      g_server:broadcastEvent(ResetTripComputerEvent.new(vehicle), nil, nil, vehicle)
    else
      g_client:getServerConnection():sendEvent(ResetTripComputerEvent.new(vehicle))
    end
  end
end
