VacationDialog = {}

function VacationDialog:GetMonthText(Month)
    if Month == 1 then  return g_i18n:getText("ui_month3") end
    if Month == 2 then  return g_i18n:getText("ui_month4") end
    if Month == 3 then  return g_i18n:getText("ui_month5") end
    if Month == 4 then  return g_i18n:getText("ui_month6") end
    if Month == 5 then  return g_i18n:getText("ui_month7") end
    if Month == 6 then  return g_i18n:getText("ui_month8") end
    if Month == 7 then  return g_i18n:getText("ui_month9") end
    if Month == 8 then  return g_i18n:getText("ui_month10") end
    if Month == 9 then  return g_i18n:getText("ui_month11") end
    if Month == 10 then  return g_i18n:getText("ui_month12") end
    if Month == 11 then  return g_i18n:getText("ui_month1") end
    if Month == 12 then  return g_i18n:getText("ui_month2") end
end

function VacationDialog:GetTextBySkipDays(SkipDays)
    local daysPerPeriod = g_currentMission.environment.daysPerPeriod
    local currentDay = g_currentMission.environment.currentDayInPeriod
    local currentPeriod = g_currentMission.environment.currentPeriod

    local i = 1

    while true do
        local totalDays = currentDay + i
        local newPeriod = currentPeriod
        local newDay = totalDays

        while newDay > daysPerPeriod do
            newDay = newDay - daysPerPeriod
            newPeriod = newPeriod + 1
            if newPeriod > 12 then
                newPeriod = 1
            end
        end

        if i == SkipDays then
            return string.format("%s %d", VacationDialog:GetMonthText(newPeriod), newDay);
        end

        i = i + 1
    end
end

function VacationDialog:GetDataBySkipDays(SkipDays)
    local daysPerPeriod = g_currentMission.environment.daysPerPeriod
    local currentDay = g_currentMission.environment.currentDayInPeriod
    local currentPeriod = g_currentMission.environment.currentPeriod

    local i = 1

    while true do
        local totalDays = currentDay + i
        local newPeriod = currentPeriod
        local newDay = totalDays

        while newDay > daysPerPeriod do
            newDay = newDay - daysPerPeriod
            newPeriod = newPeriod + 1
            if newPeriod > 12 then
                newPeriod = 1
            end
        end

        if i == SkipDays then
            return {Period = newPeriod, Day = newDay, SkipDays = i}
        end

        i = i + 1
    end
end

function VacationDialog:show(Callback)
    VacationDialog.OrginalCallback = Callback;
    VacationDialog.MaxDays = g_currentMission.environment.daysPerPeriod * 6;

    local Text = g_i18n:getText("text_VacationTarget") .. "\n" .. string.format(g_i18n:getText("text_DateNow"), VacationDialog:GetMonthText(g_currentMission.environment.currentPeriod), g_currentMission.environment.currentDayInPeriod)
    local Title = g_i18n:getText("input_VacationAction");
    local Yes = g_i18n:getText("button_confirm");
    local No = g_i18n:getText("button_cancel");

    SleepDialog.show(Text, VacationDialog.Callback, VacationDialog)
    SleepDialog.INSTANCE:setButtonTexts(Yes, No)
    SleepDialog.INSTANCE:setTitle(Title)

    SleepDialog.INSTANCE.targetTimes = {}
    VacationDialog.Targets = {}

    local daysPerPeriod = g_currentMission.environment.daysPerPeriod
    local currentDay = g_currentMission.environment.currentDayInPeriod
    local currentPeriod = g_currentMission.environment.currentPeriod
    local CurrentSeason = math.ceil(currentPeriod / 3);

    local LimitToNextSesaon = g_currentMission.environment.daysPerPeriod ~= g_currentMission.environment.plannedDaysPerPeriod;

    for i = 1, VacationDialog.MaxDays do
        local totalDays = currentDay + i
        local newPeriod = currentPeriod
        local newDay = totalDays

        while newDay > daysPerPeriod do
            newDay = newDay - daysPerPeriod
            newPeriod = newPeriod + 1
            if newPeriod > 12 then
                newPeriod = 1
            end
        end

        local dateStr = string.format("%s %d", VacationDialog:GetMonthText(newPeriod), newDay)
        table.insert(SleepDialog.INSTANCE.targetTimes, dateStr)
        table.insert(VacationDialog.Targets, {Period = newPeriod, Day = newDay, SkipDays = i})

        if LimitToNextSesaon and math.ceil(newPeriod / 3) ~= CurrentSeason then 
            break  
        end
    end

    SleepDialog.INSTANCE.targetTimeElement:setTexts(SleepDialog.INSTANCE.targetTimes)
    SleepDialog.INSTANCE.targetTimeElement:setState(1)
    SleepDialog.INSTANCE.selectedTargetTime = 0;
end

function VacationDialog:Callback(Yes, Period, Day, SkipDays)
    local Selected = VacationDialog.Targets[SleepDialog.INSTANCE.selectedTargetTime + 1];
    VacationDialog:OrginalCallback(Yes, Selected.Period, Selected.Day, Selected.SkipDays)
    VacationDialog.OrginalCallback = nil
end