---
--- Created by Ragman2414.
--- DateTime: 29.01.2022
---


ChangeMaintenanceSettingsEvent = {}
ChangeMaintenanceSettingsEvent_mt = Class(ChangeMaintenanceSettingsEvent, Event)
InitEventClass(ChangeMaintenanceSettingsEvent, "ChangeMaintenanceSettingsEvent")

ChangeMaintenanceSettingsEvent.NUM_BITS_SETTINGS_ID = 1
ChangeMaintenanceSettingsEvent.NUM_BITS_STATE = 2

---Create instance of Event class
-- @return table self instance of class event
function ChangeMaintenanceSettingsEvent.emptyNew()
    local self = Event.new(ChangeMaintenanceSettingsEvent_mt)
    return self
end


---Create new instance of event
-- @param table object object
-- @param boolean isBlocked is blocked
function ChangeMaintenanceSettingsEvent.new(settingsId, state)
    local self = ChangeMaintenanceSettingsEvent.emptyNew()
    self.settingsId = settingsId
    self.state = state
    return self
end


---Called on client side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ChangeMaintenanceSettingsEvent:readStream(streamId, connection)
    self.settingsId =   streamReadString(streamId, ChangeMaintenanceSettingsEvent.NUM_BITS_SETTINGS_ID)
    self.state = streamReadInt8(streamId, ChangeMaintenanceSettingsEvent.NUM_BITS_STATE)
    self:run(connection)

end


---Called on server side on join
-- @param integer streamId streamId
-- @param integer connection connection
function ChangeMaintenanceSettingsEvent:writeStream(streamId, connection)
    streamWriteString(streamId, self.settingsId, ChangeMaintenanceSettingsEvent.NUM_BITS_SETTINGS_ID)
    streamWriteInt8(streamId, self.state,ChangeMaintenanceSettingsEvent.NUM_BITS_STATE)
end


---Run action on receiving side
-- @param integer connection connection
function ChangeMaintenanceSettingsEvent:run(connection)

    if(self.settingsId == "maintenanceCost") then
        g_r_maintenance.maintenanceCost = self.state * 0.25
    elseif(self.settingsId == "maintenanceDuration") then
        g_r_maintenance.maintenanceDuration = self.state * 0.25
    elseif(self.settingsId == "wearDuration") then
        g_r_maintenance.wearDuration = self.state * 0.25
    elseif(self.settingsId == "wearCost") then
        g_r_maintenance.wearCost = self.state * 0.25
    end
    if g_server ~= nil then
        g_server:broadcastEvent(self, false)
    end
end

